//***********************************************************************
//
//  Sample Program for LCD Screen
//
//  Target Machine : CPT-711
//
//  Function:
//  void clr_scr(void)       : Clear LCD display
//  int  GetFont(void)       : Get current font information
//  int  GetVideoMode(void)  : Get current display mode information
//
//  void SetFont(int font)   : Select the font to be used afterwards
//                                (6* 8 font) FONT_6*8 = 1
//                                (8*16 font) FONT_8*16 = 2
//
//  void SetVideoMode(int mode) : Select video mode for the display
//                                       VIDEO_NORMAL = 0
//                                       VIDEO_REVERSE = 1
//
//  SYNTECH INFORMATION CO., LTD.
//
//***********************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int  iy, iFont, iMode;

    clr_scr();

    iFont = GetFont();
    iMode = GetVideoMode();

    if (iFont == 1)
        {
        iy = 1;
        gotoxy (0, iy);
        puts ("FONT SIZE:6*8");
        iy++;
        }
    else
        {
        iy = 2;
        gotoxy (0, iy);
        puts ("FONT SIZE:8*16");
        iy += 2;
        }

    gotoxy (0, iy);
    if (iMode == 0)
        puts ("NORMAL MODE");
    else
        puts ("REVERSE MODE");

    SetFont (2);
    SetVideoMode (1);

    gotoxy (0, 7);
    puts ("LCD SCREEN TEST");

    SetFont (1);
    SetVideoMode (0);

    while (getchar() != KEY_ESC);
    }
//-------------------------------------------------------------------------//
